IF NOT EXISTS (SELECT 1 FROM SYS.COLUMNS WHERE NAME = 'CD_BIO' AND OBJECT_ID = OBJECT_ID('RC_CLI_BIOMETRIA'))
BEGIN

	IF EXISTS (SELECT 1
				FROM sys.change_tracking_tables 
				WHERE object_id = OBJECT_ID('RC_CLI_BIOMETRIA'))
	BEGIN
		ALTER TABLE RC_CLI_BIOMETRIA
		DISABLE CHANGE_TRACKING;
	END

	ALTER TABLE RC_CLI_BIOMETRIA 
	DROP CONSTRAINT RC_CLI_BIOMETRIA_PKEY;

	-- Adicionar a coluna CD_BIO
	ALTER TABLE RC_CLI_BIOMETRIA
	ADD CD_BIO int NOT NULL DEFAULT 1;

	-- Criar a nova chave primria com as trs colunas
	ALTER TABLE RC_CLI_BIOMETRIA
	ADD CONSTRAINT RC_CLI_BIOMETRIA_PKEY PRIMARY KEY (CD_EMP, CD_CLI, CD_BIO);

	ALTER TABLE RC_CLI_BIOMETRIA
	ENABLE CHANGE_TRACKING;

END

IF NOT EXISTS (SELECT 1 FROM SYS.COLUMNS WHERE NAME = 'DT_CAD' AND OBJECT_ID = OBJECT_ID('RC_CLI_BIOMETRIA'))
BEGIN
	-- Adicionar a coluna DT_CAD
	ALTER TABLE RC_CLI_BIOMETRIA 
	ADD DT_CAD datetime DEFAULT GETDATE() NOT NULL;
END